/************************************************************************
 *
 * \file: Server.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTOT_SERVER_H
#define AAUTOT_SERVER_H

#include <map>
#include <string>

#include <aauto/util/shared_ptr.h>
#include <aauto/AoapTransport.h>
#include "utility/Singleton.h"
#include "utility/PluginManager.h"
#include "utils/IStoppable.h"
#include "session/Session.h"
#include "utils/AAutoLayerManager.h"
#include "utils/IConfiguration.h"
#include "utils/EventDispatcher.h"

namespace adit { namespace aauto {


// handles switching, transport and session creation
class Server : public adit::utility::Singleton<Server>, public IStoppable , public EventDispatcher
{
public:
    Server();
    ~Server();

    bool init(const std::string& inConfigPath);
    void cleanUp();

    // IStoppable implementation
    void requestStop();

    bool switchDevice(uint32_t inVid, uint32_t inPid, std::string inSerial, aoapTransportInfo_t* outAoapTransportInfo);
    ::shared_ptr<Session> createSession(const std::string& inSerial, aoapTransportInfo_t inAoapTransportInfo, TestParameter inParameter);
    ::shared_ptr<Session> getSession(const std::string& inSerial);
    /**
     * @brief Search for the session identified by inSerial and destroy only this session
     *
     * @param inSerial Serial number of the MD which was assigned as key to identify session
     */
    void destroySession(const std::string& inSerial);
    /**
     * @brief Iterate the session list and destroy all current sessions
     */
    void destroySession(void);

    void onByeByeRequest(std::string inSerial);

    inline IConfiguration* GetConfig() { return mConfig; }

    pthread_mutex_t sessionMutex;

private:
    bool running;

    // list of sessions; mapped to serial number
    std::map<std::string, ::shared_ptr<Session>> mSessions;
    utility::PluginManager pluginManager;

    ::shared_ptr<aautoLayerManager>   layerManager;

    IDynamicConfiguration* mConfig;
};


} } /* namespace adit { namespace aauto */
#endif /* AAUTOT_SERVER_H */
